'-------------------------------------------------------------------------------
'Designer                 : Abhishek kumar
'filename                 : smarthome.bas
'micro                    : ATMEGA16
'-------------------------------------------------------------------------------
$regfile = "m16def.dat"
$crystal = 8000000

'####################################### PORTS configuration
Config Portb = Output                                       'LCD
Config Porta = Input                                        'sensors
Reset Porta.4                                               'pir sensror


Config Portc = Output                                       'relays

Config Pind.0 = Input                                       'RXD serial
Config Pind.1 = Input                                       'TXD serial

Config Pind.3 = Input                                       'bluetooth LINK STATUS input
Reset Portd.3

Config Pind.4 = Output                                      'buzzer

Config Pind.5 = Output                                      'gate motor driver pin
Config Pind.6 = Output                                      'gate motor driver pin
Reset Portd.5                                               'stop the door motor
Reset Portd.6                                               'stop the door motor

Config Pind.7 = Input                                       'gate status sensor uSwitch (active low)
Set Portd.7                                                 'pull high door sensor pin

Enable Interrupts                                           'enable global interrupts

'####################################### EEPROM file generation (this is not a part of program code)
$eeprom                                                     'to store data lines in EEP file
'$eepromhex                                                  'store in hex format(use if programming with avr studio/ponyprog)
Data 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 50             'actual data to store in first nine registers (we will not use the first register in eeprom)

'####################################### LCD configuration
Config Lcd = 16 * 2
Config Lcdbus = 4
Config Lcdmode = Port
Config Lcdpin = Pin , Db4 = Portb.0 , Db5 = Portb.1 , Db6 = Portb.2 , Db7 = Portb.3 , E = Portc.6 , Rs = Portc.7

'####################################### Serial port configuration and interrupt
Config Com1 = 38400 , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0
Enable Urxc                                                 'serial receive complete interrupt
On Urxc Serialget                                           'serial receive complete ISR label config

'####################################### ADC configuration
Config Adc = Single , Prescaler = Auto , Reference = Internal

'####################################### Timer configuration
Config Timer0 = Timer , Prescale = 1024
Enable Timer0
Enable Ovf0
On Ovf0 Display_timer

Config Timer1 = Pwm , Pwm = 8 , Compare B Pwm = Clear Up , Prescale = 8       'for buzzer sound at OC1B pin(PD.4)
Compare1b = 0                                               'turn pwm off first (0% duty cycle),buzzer is off now
'the timers are automatically started after configuration

'####################################### Variables declaration
Dim W As Word                                               'ADC read variable
Dim Abuff As Byte                                           'serial input buffer load variable

Dim T As Byte                                               'used in display update and android app screens update
T = 0

Dim M As Byte                                               'for reading/writing eeprom

Dim S As String * 10                                        'used in extracting the programmed sensor values from encoded serial commands
Dim I As Byte                                               'used in extracting the programmed sensor values from encoded serial commands

Dim V As Single                                             'used in converting single into formatted string and other equations
Dim Tmpin As String * 6
Dim Tmpout As String * 6
Dim Lightin As String * 6
Dim Lightout As String * 6

Dim Proglight1 As Byte                                      'to hold program value for light 1
Dim Proglight2 As Byte                                      'to hold program value for light 2
Dim Progfan As Byte                                         'to hold program value for fan
Dim Progmotion As Byte                                      'to hold program value for motion sensor alarm
Dim Progsleep As Byte                                       'sleepmode flag
Dim Progfire As Byte                                        'hold the fire alarm temperature threshold value

Dim Emergency As Bit                                        'used to remeber to shut off alarm if it was raised due to fire/lpg leak
Emergency = 0

Dim Lpg As Bit

'###########################################################################################################################
'###########################################################################################################################
'###########################################################################################################################
'############################################################################################################## Main program
Cursor Off
'startup message
Cls
Lcd "   Welcome to"
Lowerline
Lcd "   Smart Home"
Compare1b = 200                                             'turn buzzer ON

'recover the previous state of appliances now,reading the eeprom
Readeeprom M , 1                                            'read the previous state of light1
Portc.3 = M                                                 'update its status according to eeprom content

Readeeprom M , 2                                            'read the previous state of light2
Portc.2 = M                                                 'update its status according to eeprom content

Readeeprom M , 3                                            'read the previous state of TV
Portc.1 = M                                                 'update its status according to eeprom content

Readeeprom M , 4                                            'read the previous state of FAN
Portc.0 = M                                                 'update its status according to eeprom content

'recover the program values
Readeeprom Proglight1 , 5
Readeeprom Proglight2 , 6
Readeeprom Progfan , 7
Readeeprom Progmotion , 8
Readeeprom Progsleep , 9
Readeeprom Progfire , 10

Wait 1
Compare1b = 0                                               'turn buzzer OFF

Do                                                          'main infinite loop starts here

'@@@@@@@@@@@@@@@@@@@@@@@@@ read all sensors,appliances and bluetooth link status
'-------------------Temperature intside
W = Getadc(7)                                               'read the temperature sensor inside the home
V = W * 2.56                                                '2.56 volt internal ADC refrence
V = V / 1023                                                'voltage at ADC input pin is calculated here
V = V * 100
Tmpin = Fusing(v , "##.#")

'-------------------Temperature outside
W = Getadc(6)                                               'read the temperature sensor outside the home
V = W * 2.56
V = V / 1023
V = V * 100
Tmpout = Fusing(v , "##.#")

'-------------------Light inside
W = Getadc(3)                                               'read the light sensor inside the home
V = W * -100
V = V / 1023
V = V + 100
Lightin = Fusing(v , "##.#")

'-------------------Light outside
W = Getadc(2)                                               'read the light sensor outide the home
V = W * -100
V = V / 1023
V = V + 100
Lightout = Fusing(v , "##.#")

'-------------------LPG
W = Getadc(5)                                               'read the LPG sensor
If W < 200 Then
   Lpg = 1                                                  'LPG leaking
Else
   Lpg = 0                                                  'no LPG leak is there
End If

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ "SENSOMATE FEATURE" automatic actuation of appliances,alarms and sleep mode function
If Progmotion > 0 Then                                      'if motion sensor is programmed to raise an alarm

   If Pina.4 = 1 Then                                       'if motion is detected
      Set Portc.2                                           'switch ON light2(outside)
      M = 1
      Writeeeprom M , 2                                     'update the eeprom for non volatile state of light2
      Waitms 500                                            'to prevent flickering of relay
   Else                                                     'if no motion is detected
      Reset Portc.2
      M = 0
      Writeeeprom M , 2                                     'update the eeprom for non volatile state of light2
      Waitms 500                                            'to prevent flickering of relay                                        'turn buzzer OFF
   End If

End If

If Progfan > 0 Then                                         'if fan is programmed

   If Val(tmpin) > Progfan Then                             'if temperature inside exceeds the programmed fan threshold
      Set Portc.0                                           'turn fan ON
      M = 1
      Writeeeprom M , 4                                     'update the eeprom for non volatile state of fan
      Wait 1                                                'to prevent flickering of relay
   Else
      Reset Portc.0                                         'turn fan ON
      M = 0
      Writeeeprom M , 4                                     'update the eeprom for non volatile state of fan
      Wait 1                                                'to prevent flickering of relay
   End If

End If

If Proglight1 > 0 Then                                      'if light1 is programmed

   If Val(lightout) < Proglight1 Then                       'if the light intensity outside is less than the programmed threshold value
      Set Portc.3
      M = 1
      Writeeeprom M , 1                                     'update the eeprom for non volatile state of light1
      Waitms 500                                            'to prevent flickering of relay
   Else
      Reset Portc.3
      M = 0
      Writeeeprom M , 1                                     'update the eeprom for non volatile state of light1
      Waitms 500                                            'to prevent flickering of relay
   End If

End If

If Proglight2 > 0 Then                                      'if light2 is programmed

   If Val(lightout) < Proglight2 Then                       'if the light intensity outside is less than the programmed threshold value
      Set Portc.2                                           'switch ON light2(outside)
      M = 1
      Writeeeprom M , 2                                     'update the eeprom for non volatile state of light2
      Waitms 500                                            'to prevent flickering of relay
   Else
      Reset Portc.2
      M = 0
      Writeeeprom M , 2                                     'update the eeprom for non volatile state of light2
      Waitms 500                                            'to prevent flickering of relay
   End If

End If

'-----------------------------Sleep mode alarms
If Progsleep > 0 Then                                       'if sleep mode is activated
   If Pina.4 = 1 Or Pind.7 = 1 Then                         'if motion is detected or door gets open
      Compare1b = 200                                       'turn on buzzer
      Stop Timer0                                           'freeze display

      'Turn On All Lights
      Set Portc.3
      Set Portc.2
      M = 1
      Writeeeprom M , 1
      Writeeeprom M , 2

      Cls
      Lcd "SECURITY"
      Lowerline
      Lcd "BROKEN !!!"
      Waitms 400
   End If
End If

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ other unceasable alarms (LPG and fire)
If Lpg = 1 Or Val(tmpin) > Progfire Then                    'if lpg is leaking or there is a fire(temp inside > fire threshold)
   Emergency = 1                                            'raise emergency flag(used in shutting alarm only)
   Compare1b = 200                                          'raise the alarm

   'turn OFF all devices
   Reset Portc.3
   Reset Portc.2
   Reset Portc.1
   Reset Portc.0
   M = 0
   Writeeeprom M , 1
   Writeeeprom M , 2
   Writeeeprom M , 3
   Writeeeprom M , 4

   'turn off sensomate
   Proglight1 = 0
   Writeeeprom Proglight1 , 5
   Proglight2 = 0
   Writeeeprom Proglight2 , 6
   Progfan = 0
   Writeeeprom Progfan , 7

   'if door is closed, open the door to exhaust LPG leak
   If Pind.7 = 0 Then                                       'if door is closed
         'move motor in anticlockwise direction
         Set Portd.6
         Reset Portd.5

         Waitms 1800                                        'experimental timing until gate gets opened sufficiently

         'stop motor now
         Reset Portd.6
         Reset Portd.5
   End If

   Stop Timer0                                              'freeze LCD display
   Cls
     Lcd "!! EMERGENCY !!"
   Lowerline
    If Lpg = 1 And Val(tmpin) < Progfire Then               'only LPG leak is there
       Lcd "LPG leak!"
    Elseif Lpg = 0 And Val(tmpin) > Progfire Then           'only fire has broken
       Lcd "Fire in home!"
    Elseif Lpg = 1 And Val(tmpin) > Progfire Then           'both fire has broken and LPG leak is there
       Lcd "LPG & fire alert"
    End If
   Waitms 500

Else                                                        'no emergency(no worries)
   If Emergency = 1 Then                                    'if previously was emergency that raised the alarm
      Emergency = 0                                         'turn emergency flag off as everything is under limits now
      Compare1b = 0                                         'stop buzzer now
      Start Timer0                                          'release the LCD display
   End If
End If

Loop
End                                                         'end program
'##################################################################################################### Main program end here
'###########################################################################################################################
'###########################################################################################################################
'###########################################################################################################################

'#################################################################### Timer0 ISR
Display_timer:
Incr T
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ serial commands transmission to update android client(smartphone app)
If Pind.3 = 1 Then
   If T = 0 Or T = 30 Or T = 60 Or T = 90 Or T = 120 Or T = 150 Or T = 180 Or T = 210 Then

          Print "@";

          If Portc.3 = 1 Then                               'if LIGHT1 os ON
             Print "Z";
          Else
             Print "z";
          End If

          If Portc.2 = 1 Then                               'if LIGHT2 os ON
             Print "Y";
          Else
             Print "y";
          End If

          If Portc.1 = 1 Then                               'if TV is ON
             Print "X";
          Else
             Print "x";
          End If

          If Portc.0 = 1 Then                               'if FAN os ON
             Print "W";
          Else
             Print "w";
          End If

          If Pina.4 = 1 Then                                'if motion is detected
             Print "F";
          Else
             Print "f";
          End If

          If Lpg = 1 Then
             Print "G";
          Else
             Print "g";
          End If

          If Pind.7 = 0 Then                                'door closed
             Print "u";
          Else                                              'door open
             Print "U";
          End If

          If Progsleep = 1 Then                             'if sleep mode is ON
             Print "T";
          Else
             Print "t";
          End If

          If Progmotion = 1 Then
             Print "S";
          Else
             Print "s";
          End If


          Print "K" ; Tmpin ; "k";
          Print "J" ; Tmpout ; "j";
          Print "I" ; Lightin ; "i";
          Print "H" ; Lightout ; "h";
          Print "R" ; Proglight1 ; "r";
          Print "P" ; Proglight2 ; "p" ;
          Print "N" ; Progfan ; "n" ;
          Print "#"
   End If
End If

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ update the LCD display
If T = 0 Then                                               'for first apprx 1.5 seconds

   Cls
   Lcd "TMP IN:" ; Tmpin ; " C"
   Lowerline
   Lcd "TMP OUT:" ; Tmpout ; " C"

   If Pind.3 = 1 Then
      Locate 1 , 16
      Lcd "B"                                               'show on the corner of LCD that bluetooth link is available
   Else
     Locate 1 , 16
      Lcd "*"                                               'update the corner of LCD that bluetooth link is not available
   End If


Elseif T = 52 Then                                          'for second apprx 1.5 seconds

   Cls
   Lcd "LIGHT IN:" ; Lightin ; "%"
   Lowerline
   Lcd "LIGHT OUT:" ; Lightout ; "%"

   If Pind.3 = 1 Then
      Locate 1 , 16
      Lcd "B"                                               'show on the corner of LCD that bluetooth link is available
   Else
     Locate 1 , 16
      Lcd "*"                                               'update the corner of LCD that bluetooth link is not available
   End If

Elseif T = 105 Then                                         'for third apprx 1.5 seconds

   Cls
   If Pina.4 = 1 Then
      Lcd "MOTION: YES    "
   Else
      Lcd "MOTION: NO     "
   End If

   Lowerline
   If Lpg = 1 Then
      Lcd "LPG: LEAK       "
   Else
      Lcd "LPG: NO LEAK    "
   End If

   If Pind.3 = 1 Then
      Locate 1 , 16
      Lcd "B"                                               'show on the corner of LCD that bluetooth link is available
   Else
     Locate 1 , 16
      Lcd "*"                                               'update the corner of LCD that bluetooth link is not available
   End If

Elseif T = 156 Then                                         'for fourth apprx 1.5 seconds

   Cls
   If Pind.7 = 1 Then
      Lcd "DOOR: OPEN     "
   Else
      Lcd "DOOR: CLOSE    "
   End If

   Lowerline
   If Pind.3 = 1 Then
      Lcd "BT Link: PRESENT"
   Else
      Lcd "BT Link: ABSENT"
   End If

   If Pind.3 = 1 Then
      Locate 1 , 16
      Lcd "B"                                               'show on the corner of LCD that bluetooth link is available
   Else
     Locate 1 , 16
      Lcd "*"                                               'update the corner of LCD that bluetooth link is not available
   End If

Elseif T = 208 Then                                         'for fifth apprx 1.5 seconds
   Cls
   Locate 1 , 1
   If Portc.3 = 0 Then
      Lcd "L1=OFF"
   Else
      Lcd "L1=ON"
   End If

   Locate 1 , 8
   If Portc.2 = 0 Then
      Lcd "L2=OFF"
   Else
      Lcd "L2=ON"
   End If

   Locate 2 , 1
   If Portc.1 = 0 Then
      Lcd "TV=OFF"
   Else
      Lcd "TV=ON"
   End If

   Locate 2 , 8
   If Portc.0 = 0 Then
      Lcd "FAN=OFF"
   Else
      Lcd "FAN=ON"
   End If

   If Pind.3 = 1 Then
      Locate 1 , 16
      Lcd "B"                                               'show on the corner of LCD that bluetooth link is available
   Else
     Locate 1 , 16
      Lcd "*"                                               'update the corner of LCD that bluetooth link is not available
   End If

End If

Return


'############################################## Serial data receive complete ISR
Serialget:
Abuff = Inkey()                                             'read the input buffer

Select Case Abuff                                           ' go for process it

   '--------------------------Light1
   Case 65 :                                                'A turn ON light1 command
      Set Portc.3
      M = 1
      Writeeeprom M , 1                                     'update the eeprom for non volatile state of light1

      Proglight1 = 0                                        'if ON,turn off sensomate for light1 if user wants manual control
      Writeeeprom Proglight1 , 5

      Cls
      Lcd "LIGHT1 = ON"
      Lowerline
      Lcd "L1= UNPROGRAMMED"
      Waitms 500

   Case 97 :
      Reset Portc.3                                         'a turn OFF light1 command
      M = 0
      Writeeeprom M , 1                                     'update the eeprom for non volatile state of light1

      Proglight1 = 0                                        'if ON,turn off sensomate for light1 if user wants manual control
      Writeeeprom Proglight1 , 5

      Cls
      Lcd "LIGHT1 = OFF"
      Lowerline
      Lcd "L1= UNPROGRAMMED"
      Waitms 500

   '--------------------------Light2
   Case 66 :
      Set Portc.2                                           'B turn ON light2 command
      M = 1
      Writeeeprom M , 2                                     'update the eeprom for non volatile state of light2

      Proglight2 = 0                                        'if ON,turn off sensomate for light2 if user wants manual control
      Writeeeprom Proglight2 , 6

      Cls
      Lcd "LIGHT2 = ON"
      Lowerline
      Lcd "L2= UNPROGRAMMED"
      Waitms 500

   Case 98 :
      Reset Portc.2                                         'b turn OFF light2 command
      M = 0
      Writeeeprom M , 2                                     'update the eeprom for non volatile state of light2

      Proglight2 = 0                                        'if ON,turn off sensomate for light2 if user wants manual control
      Writeeeprom Proglight2 , 6

      Cls
      Lcd "LIGHT2 = OFF"
      Lowerline
      Lcd "L2= UNPROGRAMMED"
      Waitms 500

   '--------------------------TV
   Case 67 :
      Set Portc.1                                           'C turn ON TV command
      M = 1
      Writeeeprom M , 3                                     'update the eeprom for non volatile state of tv

      Cls
      Lcd "TV = ON"
      Waitms 500

   Case 99 :
      Reset Portc.1                                         'c turn OFF TV command
      M = 0
      Writeeeprom M , 3                                     'update the eeprom for non volatile state of tv

      Cls
      Lcd "TV = OFF"
      Waitms 500

   '--------------------------FAN
   Case 68 :
      Set Portc.0                                           'D turn ON Fan command
      M = 1
      Writeeeprom M , 4                                     'update the eeprom for non volatile state of fan

      Progfan = 0                                           'if ON,turn off sensomate for fan if user wants manual control
      Writeeeprom Progfan , 7

      Cls
      Lcd "FAN = ON"
      Lowerline
      Lcd "FAN UNPROGRAMMED"
      Waitms 500

   Case 100 :
      Reset Portc.0                                         'd turn OFF Fan command
      M = 0
      Writeeeprom M , 4                                     'update the eeprom for non volatile state of fan

      Progfan = 0                                           'if ON,turn off sensomate for fan if user wants manual control
      Writeeeprom Progfan , 7

      Cls
      Lcd "FAN = OFF"
      Lowerline
      Lcd "FAN UNPROGRAMMED"
      Waitms 500

   '--------------------------All appliances
   Case 69 :                                                'E turn ON all appliances command

      Set Portc.3
      Set Portc.2
      Set Portc.1
      Set Portc.0

      M = 1
      Writeeeprom M , 1
      Writeeeprom M , 2
      Writeeeprom M , 3
      Writeeeprom M , 4

      'turn off sensomate
      Proglight1 = 0
      Writeeeprom Proglight1 , 5
      Proglight2 = 0
      Writeeeprom Proglight2 , 6
      Progfan = 0
      Writeeeprom Progfan , 7

      Cls
      Lcd "ALL APPL = ON"
      Lowerline
      Lcd "SEN UNPROGRAMMED"
      Waitms 500

   Case 101 :                                               'e turn OFF all appliances command

      Reset Portc.3
      Reset Portc.2
      Reset Portc.1
      Reset Portc.0

      M = 0
      Writeeeprom M , 1
      Writeeeprom M , 2
      Writeeeprom M , 3
      Writeeeprom M , 4

      'turn off sensomate
      Proglight1 = 0
      Writeeeprom Proglight1 , 5
      Proglight2 = 0
      Writeeeprom Proglight2 , 6
      Progfan = 0
      Writeeeprom Progfan , 7

      Cls
      Lcd "ALL APPL = OFF"
      Lowerline
      Lcd "SEN UNPROGRAMMED"
      Waitms 500

   '--------------------------Sleep mode
   Case 83:                                                 'S activate the sleep mode

      'turn off all appliances except fan
      Reset Portc.3
      Reset Portc.2
      Reset Portc.1
      M = 0
      Writeeeprom M , 1
      Writeeeprom M , 2
      Writeeeprom M , 3

      'turn off sensomate for appliances except for fan
      Proglight1 = 0
      Writeeeprom Proglight1 , 5
      Proglight2 = 0
      Writeeeprom Proglight2 , 6

      Progsleep = 1                                         'sleep mode flag
      Writeeeprom Progsleep , 9

      Cls
      Lcd "   SLEEP MODE"
      Lowerline
      Lcd "   ACTIVATED"
      Waitms 500

   Case 84:                                                 'T deactivate the sleep mode and shut all alarms running

      Compare1b = 0                                         'shut off the buzzer
      Start Timer0                                          'start the freezed display

      Progsleep = 0                                         'sleep mode deactivated
      Writeeeprom Progsleep , 9

      Cls
      Lcd "   SLEEP MODE"
      Lowerline
      Lcd "   DEACTIVATED"
      Waitms 500

   '--------------------------Door control
   Case 70:                                                 'F open the door
      If Pind.7 = 0 Then                                    'if door is closed

         'move motor in anticlockwise direction
         Set Portd.6
         Reset Portd.5

         Waitms 450                                         'experimental timing until gate gets opened sufficiently

         'stop motor now
         Reset Portd.6
         Reset Portd.5

         Cls
         Lcd "Door opened"
         Waitms 500

      End If

   Case 78:                                                 'N close the door
      If Pind.7 = 1 Then                                    'if door is open

         'move motor in clockwise direction until door sensor senses that the door is closed now
         Do

            'move motor in clockwise direction
            Reset Portd.6
            Set Portd.5

         Loop Until Pind.7 = 0                              'loop until door gets closed completely

         'stop motor now
         Reset Portd.6
         Reset Portd.5

         Cls
         Lcd "Door closed"
         Waitms 500

      End If

   '-----------------------Program motion sensor alarm
   Case 71 :                                                'G set motion sensor to switch ON light2 if it detects motion
      Progmotion = 1
      Writeeeprom Progmotion , 8

      Proglight2 = 0                                        'turn OFF automatic switching of light2 on percentage thresholds for light2
      Writeeeprom Proglight2 , 6

      Cls
      Lcd " MOTION SENSOR"
      Lowerline
      Lcd "ALARM TURNED ON"
      Waitms 500

   Case 103:                                                'g set motion sensor to switch OFF light2 if it detects motion
      Compare1b = 0                                         'turn buzzer OFF if it was running previously

      Progmotion = 0
      Writeeeprom Progmotion , 8

      Cls
      Lcd " MOTION SENSOR"
      Lowerline
      Lcd "ALARM TURNED OFF"
      Waitms 500

   '-----------------------Programme Light1
   Case 72:                                                 'H  ;numeric value ready to be received
      S = Chr(0)                                            'null value
      I = 1                                                 'set string pointer
   Case 104:                                                'h ;reception is over,programme light1 now
      Proglight1 = Val(s)
      Writeeeprom Proglight1 , 5

      Cls
      Lcd "LIGHT1 = " ; Proglight1
      Lowerline
      Lcd "PROGRAMMED"
      Waitms 500

   Case 73:                                                 'I ;unprogramme light1
      Proglight1 = 0
      Writeeeprom Proglight1 , 5

      Cls
      Lcd "LIGHT1"
      Lowerline
      Lcd "UNPROGRAMMED"
      Waitms 500

   '-----------------------Programme Light2
   Case 74:                                                 'J  ;numeric value ready to be received
      S = Chr(0)                                            'null value
      I = 1                                                 'set string pointer
   Case 106:                                                'j  ;reception is over,programme light2 now
      Proglight2 = Val(s)
      Writeeeprom Proglight2 , 6

      Progmotion = 0                                        'disable the motion sensor program for light2
      Writeeeprom Progmotion , 8

      Cls
      Lcd "LIGHT2 = " ; Proglight2
      Lowerline
      Lcd "PROGRAMMED"
      Waitms 500

   Case 75:                                                 'K  ;unprogramme light2
      Proglight2 = 0
      Writeeeprom Proglight2 , 6

      Cls
      Lcd "LIGHT2"
      Lowerline
      Lcd "UNPROGRAMMED"
      Waitms 500

   '-----------------------Programme Fan
   Case 76:                                                 'L  ;numeric value ready to be received
      S = Chr(0)                                            'null value
      I = 1                                                 'set string pointer
   Case 108:                                                'l  ;reception is over,programme fan now
      Progfan = Val(s)
      Writeeeprom Progfan , 7

      Cls
      Lcd "FAN = " ; Progfan
      Lowerline
      Lcd "PROGRAMMED"
      Waitms 500

   Case 77:                                                 'M  'unprogramme fan
      Progfan = 0
      Writeeeprom Progfan , 7

      Cls
      Lcd "FAN"
      Lowerline
      Lcd "UNPROGRAMMED"
      Waitms 500

   '-----------------------Programme fire sensing temperature threshold
   Case 80:                                                 'P  ;numeric value ready to be received
      S = Chr(0)                                            'null value
      I = 1                                                 'set string pointer
   Case 112:                                                'p  ;reception is over,programme fire alarm threshold now
      Progfire = Val(s)
      Writeeeprom Progfire , 10

      Cls
      Compare1b = 200                                       'buzzer on
      Lcd "Fire at > " ; Progfire ; " C"
      Lowerline
      Lcd "ALARM PROGRAMMED"
      Waitms 500
      Compare1b = 0                                         'buzzer off

   '--------------------------processing of numeric data
   Case 48 To 57 :                                          'if a numeric content is received (0-9)
      Insertchar S , I , Abuff                              'build the numeric string
      Incr I
End Select
Return